package lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.File;

public class ByteUtil {
	public static byte[] ByteReadFrom(InputStream ips) throws IOException {
		final int TCP_RECV_BYTE = 100000;
		byte[] recvByte = new byte[TCP_RECV_BYTE];
		int recvLength = ips.read(recvByte);
		if(recvLength < 0) {
			return null;
		}
		byte[] setByte = new byte[recvLength];
		System.arraycopy(recvByte, 0, setByte, 0, recvLength);

		return setByte;
	}

	public static byte[] ByteReadFromFileName(String fileName) throws IOException {
		File file = new File(fileName);
		FileInputStream fis = new FileInputStream(file);
		byte[] entireFileByte = new byte[(int)file.length()];
		byte[] buff = new byte[1024];

		int seek = 0;
		while(true) {
			int num = fis.read(buff);
			if(num < 0) {
				break;
			}
			System.arraycopy(buff, 0, entireFileByte, seek, num);
			seek += num;
		}
		return entireFileByte;
	}
}
